% Simple Example program to obtain time data from HP E1432A
% This program uses:
%    1. error check function "hpe1432_check_status.m"
%    2. Uses hpe1432get... functions to obtain actual parameters 
%    3. Also uses two HPE1432A modules to obtain 32 channels of data
% Rev 1-8-98
% Hit "Control C" to exit

BLOCKSIZE = 1024
OLDCHANNELS = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32]
CHANNELS  = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32]
SPAN = 20000.
RANGE = 10.0



[status,session] = hpe1432('init','VXI0::9,10::INSTR',1,1);   % init modules at address 9 & 10 
hpe1432_check_status(session,status);						

[status] = hpe1432('deleteAllChanGroups',session);		% Turn off all channels 
hpe1432_check_status(session,status);

[status,gid] = hpe1432('createChannelGroup',session,length(OLDCHANNELS),OLDCHANNELS);
hpe1432_check_status(session,status);

[status] = hpe1432('setActive',session,gid,'CHANNEL_OFF');  
hpe1432_check_status(session,status);
						  
[status] = hpe1432('deleteAllChanGroups',session);		% Create a group of active channels
hpe1432_check_status(session,status);

[status,gid] = hpe1432('createChannelGroup',session,length(CHANNELS),CHANNELS);
hpe1432_check_status(session,status);

[status] = hpe1432('setBlocksize',session,gid,BLOCKSIZE);	% set the block size of all active channels
hpe1432_check_status(session,status);

[status, actual_blocksize] = hpe1432('getBlocksize',session,gid);	% Get the block size of all active channels
hpe1432_check_status(session,status);
BLOCKSIZE = double(actual_blocksize)

[status] = hpe1432('setRange',session,gid,RANGE);		% Set the full scale voltage range of all active achnnels
hpe1432_check_status(session,status);

[status, actual_range] = hpe1432('getRange',session,gid);		% Get the full scale voltage range of all active achnnels
hpe1432_check_status(session,status);
RANGE = double(actual_range)

[status] = hpe1432('setSpan',session,gid,SPAN);		% set the SPAN (sample rate/2.56) 
hpe1432_check_status(session,status);

[status, actual_span] = hpe1432('getSpan',session,gid);		% get the SPAN (sample rate/2.56) 
hpe1432_check_status(session,status);
SPAN = double(actual_span)

[status] = hpe1432('setDataMode',session,gid,'BLOCK_MODE');	% Put module in block acquisition mode
hpe1432_check_status(session,status);

[status] = hpe1432('setAutoTrigger',session,gid,'MANUAL_TRIGGER');	% set trigger mode 
hpe1432_check_status(session,status);

[status] = hpe1432('initMeasure',session,gid);  		% start measurement	
hpe1432_check_status(session,status);
A=1
Xtime = 1/(SPAN*2.56):1/(SPAN*2.56):BLOCKSIZE/(SPAN*2.56);  % time axis values
while A>0,
   
[status] = hpe1432('triggerMeasure',session,gid,'NO_WAIT_FLAG'); 	 % manually trigger a block acquisition of all channels
hpe1432_check_status(session,status);

[status,data,count] = hpe1432('readFloat64Data',session,gid,'TIME_DATA',BLOCKSIZE*length(CHANNELS),'WAIT_FLAG');		
		% transfer all four channels of data at 1024 samples (blocksize) per channel
hpe1432_check_status(session,status);

plot(Xtime,reshape(data,BLOCKSIZE,length(CHANNELS))), drawnow;

A=A+1
end
% The following would normally be used to clean up the measurement when 
% finished.  In this example this never gets executed, since the example runs until
% "control C" is hit.

[status] = hpe1432('finishMeasure',session,gid);
[status] = hpe1432('close',session);

 
   